// AddTimeZone.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddTimeZone.h"
#include <comdef.h>
#include<atlbase.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddTimeZone dialog


CAddTimeZone::CAddTimeZone(CWnd* pParent /*=NULL*/)
	: CDialog(CAddTimeZone::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddTimeZone)
	m_TimeZoneName = _T("");
	m_TimeZoneDesc = _T("");
	//}}AFX_DATA_INIT
}
CAddTimeZone ::CAddTimeZone(IApplication *pApp):CDialog(CAddTimeZone::IDD, NULL)
{
	pApplication = pApp;
	pTZ.CreateInstance(__uuidof(TimeZone));
	
}

void CAddTimeZone::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddTimeZone)
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_ADDTZ_NAME, m_TimeZoneName);
	DDX_Text(pDX, IDC_ADDTZ_DESC, m_TimeZoneDesc);
	//}}AFX_DATA_MAP
}

void CAddTimeZone :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.AddString(pAccount->AccountName);
				pAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

BEGIN_MESSAGE_MAP(CAddTimeZone, CDialog)
	//{{AFX_MSG_MAP(CAddTimeZone)
	ON_BN_CLICKED(ID_ADD, OnAdd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddTimeZone message handlers

BOOL CAddTimeZone::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
 	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddTimeZone::OnAdd() 
{
		BSTR bstrAcctName;
		BSTR bstrTZName;
		BSTR bstrTZDesc;

		UpdateData(TRUE);
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}			
		
		//get the access level name and description
		bstrTZName = m_TimeZoneName.AllocSysString();
		bstrTZDesc = m_TimeZoneDesc.AllocSysString();
	//set time zone properties
		pTZ->AccountName		= bstrAcctName;
		pTZ->TimeZoneName	= bstrTZName;
		pTZ->TimeZoneDesc	= bstrTZDesc;
		//add time zone;
		long lStatus;
		long lTZID;
		pApplication->AddTimezone(pTZ, &lTZID, &lStatus);
		::SysFreeString(bstrAcctName);
		::SysFreeString(bstrTZName);
		::SysFreeString(bstrTZDesc);
		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid Account name");
			return;
		}
		if(lStatus == 601)
		{
			AfxMessageBox(L"InValid Time Zone name");
			return;
		}
		if (lStatus == 603)
		{
			AfxMessageBox(L"Invalid Time Zone Name / Description string length");
			return;
		}
		if ( lStatus == 602)
		{
			AfxMessageBox(L"Time Zone Name Exists");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time Zone Addition Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time Zone Addition succeeded");
			CDialog::OnOK();
		}
		UpdateData(FALSE);	
}
